import * as React from 'react';
import cx from 'classnames';
import themes from '../themes';
import { LinkTabComponent } from './LinkTab.types';
import { Container } from '../Container';

export const LinkTab: LinkTabComponent = (props) => {
  const { className, title, path, children, theme = 'default', ...other } = props;

  const cssTheme = themes[theme];

  return (
    <Container className={cx(className || cssTheme.container)} {...other}>
      {children}
    </Container>
  );
};
