import React from 'react';
import cx from 'classnames';
import { NavLink } from 'react-router-dom';
import { ToggleLayout } from '../ToggleLayout';
import { LinkTabToggleComponent } from './LinkTabToggle.types';

export const LinkTabToggle: LinkTabToggleComponent = ({
  theme,
  children,
  navigationTheme,
  beforeContent,
  afterContent,
  to,
}) => (
  <NavLink
    className={cx(theme.button, theme[`button_position_${navigationTheme}`])}
    activeClassName={theme.button_selected}
    to={to}
    exact
  >
    <ToggleLayout theme={theme} beforeContent={beforeContent} afterContent={afterContent}>
      {children}
    </ToggleLayout>
  </NavLink>
);
