import React from 'react';
import { Switch, Route, Redirect } from 'react-router-dom';
import themes from '../themes';
import { ThemeType } from '../types';
import { LinkTabsProps } from './LinkTabs.types';
import { TabsView } from '../TabsView';
import { LinkTabToggle } from '../LinkTabToggle';

export class LinkTabs extends React.Component<LinkTabsProps> {
  public static defaultProps = {
    navigationTheme: 'center',
    canHide: false,
    showHeader: true,
    defaultValue: 0,
    theme: ThemeType.Default,
    tone: 'default',
  };

  private renderTabs(): React.ReactElement | null {
    const { theme, width, children, redirectUrl } = this.props;

    const childrenWithProps = React.Children.map(children, (child) => {
      if (React.isValidElement(child)) {
        const { path } = child.props;
        return (
          <Route path={path} exact>
            {React.cloneElement(child, {
              theme,
              width,
            })}
          </Route>
        );
      }

      return null;
    });

    return (
      <Switch>
        {childrenWithProps}
        {redirectUrl && <Redirect to={redirectUrl} />}
      </Switch>
    );
  }

  public render(): React.ReactElement {
    const {
      className,
      classNameHeader,
      style,
      navigationTheme,
      title,
      theme,
      headerLeft,
      content,
      width,
      tone,
      showHeader,
      children,
    } = this.props;

    const cssTheme = themes[theme] || {};

    const links = React.Children.map(children, (child) => {
      if (React.isValidElement(child)) {
        const { title, buttonAfterContent, buttonBeforeContent, path } = child.props;

        return (
          <LinkTabToggle
            theme={cssTheme}
            to={path}
            beforeContent={buttonBeforeContent}
            afterContent={buttonAfterContent}
            navigationTheme={navigationTheme}
          >
            {title}
          </LinkTabToggle>
        );
      }

      return null;
    });

    return (
      <TabsView
        theme={cssTheme}
        tone={tone}
        width={width}
        showHeader={showHeader}
        title={title}
        style={style}
        className={className}
        classNameHeader={classNameHeader}
        headerLeft={headerLeft}
        buttons={links}
      >
        {content}
        {this.renderTabs()}
      </TabsView>
    );
  }
}
