import { ComponentType, ReactNode, CSSProperties } from 'react';
import { LinkTabElement } from '../LinkTab';
import { ThemeType } from '../types/ThemeType';
import { NavigationTheme } from '../types/NavigationTheme';
import { Width } from '../types/Width';
import { Tone } from '../types/Tone';

export interface LinkTabsProps {
  theme: ThemeType;
  navigationTheme: NavigationTheme;
  title?: ReactNode;
  headerLeft?: ReactNode;
  content?: ReactNode;
  canHide?: boolean;
  showHeader: boolean;
  className?: string;
  classNameHeader?: string;
  children: (LinkTabElement | undefined)[];
  style?: CSSProperties;
  width?: Width;
  tone?: Tone;
  redirectUrl?: string;
}

export type LinkTabsComponent = ComponentType<LinkTabsProps>;
