import * as React from 'react';
import cx from 'classnames';
import themes from '../themes';
import { TabComponent } from './Tab.types';
import { Container } from '../Container';

export const Tab: TabComponent = (props) => {
  const { className, title, theme = 'default', children, keepMount, lazyMount, ...other } = props;

  const cssTheme = themes[theme];

  return (
    <Container className={cx(className || cssTheme.container)} {...other}>
      {children}
    </Container>
  );
};
