import { ComponentType, ReactNode, ReactElement } from 'react';
import { ContainerProps } from '../Container';
import { ThemeType } from '../types/ThemeType';
import { Value } from '../types/Value';
import { Width } from '../types/Width';

export interface TabProps extends Omit<ContainerProps, 'title'> {
  title: ReactNode;
  children?: ReactNode;
  className?: string;
  theme?: ThemeType;
  value?: Value;
  hidden?: boolean;
  width?: Width;
  keepMount?: boolean;
  lazyMount?: boolean;
  buttonBeforeContent?: ReactNode;
  buttonAfterContent?: ReactNode;
  testid?: string;
}

export type TabComponent = ComponentType<TabProps>;
export type TabElement = ReactElement<TabProps>;

/** @deprecated use TabElement */
export type ReactTabElement = ReactElement<TabProps>;
