import React from 'react';
import cx from 'classnames';
import { ToggleLayout } from '../ToggleLayout';
import { TabToggleComponent } from './TabToggle.types';

export const TabToggle: TabToggleComponent = ({
  theme,
  active,
  children,
  navigationTheme,
  beforeContent,
  afterContent,
  onClick,
  testid
}) => (
  <button
    type="button"
    data-testid={testid}
    className={cx(theme.button, theme[`button_position_${navigationTheme}`], {
      [theme.button_selected]: active,
    })}
    onClick={onClick}
  >
    <ToggleLayout theme={theme} beforeContent={beforeContent} afterContent={afterContent}>
      {children}
    </ToggleLayout>
  </button>
);
