import { ComponentType, MouseEventHandler, ReactNode } from 'react';
import { ToggleLayoutProps, ToggleLayoutTheme } from '../ToggleLayout';
import { NavigationTheme } from '../types';

/* eslint-disable camelcase */
export interface TabToggleTheme extends ToggleLayoutTheme {
  button: string;
  button_selected: string;
  button_position_start: string;
  button_position_center: string;
  button_position_stretch: string;
}
/* eslint-enable camelcase */

export interface TabToggleProps extends ToggleLayoutProps {
  theme: TabToggleTheme;
  children: ReactNode;
  beforeContent?: ReactNode;
  afterContent?: ReactNode;
  navigationTheme?: NavigationTheme;
  active?: boolean;
  onClick?: MouseEventHandler<HTMLButtonElement>;
  testid?: string;
}

export type TabToggleComponent = ComponentType<TabToggleProps>;
