import React from 'react';
import { storiesOf } from '@storybook/react';
import { Router } from 'react-router-dom';
import { createMemoryHistory } from 'history';
import { LinkTabs } from '../LinkTabs';
import { LinkTab } from '../LinkTab';
import { ThemeType } from '../types';
import Icon from '@crm/components/dist/lego2/Icon';

const history = createMemoryHistory();

storiesOf('Tabs', module).add('default/link', () => (
  <Router history={history}>
    <LinkTabs>
      <LinkTab path="/" title="Tab 1">
        Tab 1
      </LinkTab>
      <LinkTab path="/tab2" title="Tab 2">
        Tab 2
      </LinkTab>
    </LinkTabs>
  </Router>
));

storiesOf('Tabs', module).add('top/link', () => (
  <Router history={history}>
    <LinkTabs theme={ThemeType.Top}>
      <LinkTab path="/" title="Tab 1">
        Tab 1
      </LinkTab>
      <LinkTab path="/tab2" title="Tab 2">
        Tab 2
      </LinkTab>
    </LinkTabs>
  </Router>
));

storiesOf('Tabs', module).add('icon/link', () => (
  <div style={{ backgroundColor: '#F1F0EF' }}>
    <Router history={history}>
      <LinkTabs theme={ThemeType.Icon}>
        <LinkTab path="/" title="Дела на день" buttonBeforeContent={<Icon svg="menu" />}>
          Tab 1
        </LinkTab>
        <LinkTab path="/tab2" title="Календарь" buttonBeforeContent={<Icon svg="settings" />}>
          Tab 2
        </LinkTab>
        <LinkTab path="/tab3" title="Все активности" buttonBeforeContent={<Icon svg="person" />}>
          Tab 3
        </LinkTab>
      </LinkTabs>
    </Router>
  </div>
));
