import { ComponentType, ReactNode, CSSProperties } from 'react';
import { TabElement } from '../Tab';
import { Tone, Width, ThemeType, Value, NavigationTheme } from '../types';

export interface TabsProps {
  theme: ThemeType;
  value?: Value;
  navigationTheme: NavigationTheme;
  title?: ReactNode;
  headerLeft?: ReactNode;
  headerRight?: ReactNode;
  content?: ReactNode;
  canHide?: boolean;
  showHeader: boolean;
  defaultValue: Value;
  className?: string;
  classNameHeader?: string;
  children: TabElement[];
  style?: CSSProperties;
  onDidUpdate?: (prevTabIndex: number, tabIndex: number) => void;
  onChange?: (value: Value) => void;
  width?: Width;
  tone?: Tone;
  testid?: string
}

export interface TabsState {
  value: Value;
}

export type TabsComponent = ComponentType<TabsProps>;
