import React, { FC } from 'react';
import cx from 'classnames';
import { TabsViewProps } from './TabsView.types';
import { Container } from '../Container';

export const TabsView: FC<TabsViewProps> = ({
  className,
  classNameHeader,
  style,
  title,
  theme,
  headerLeft,
  headerRight,
  width,
  tone = 'default',
  children,
  buttons,
  hasVisibleTabContent,
  showHeader = true,
  testid
}) => {
  return (
    <Container
      className={cx(className, theme.b, theme[`b_tone_${tone}`])}
      width={width}
      style={style}
    >
      {showHeader && (
        <div
          data-testid={testid}
          className={cx(classNameHeader, theme.header, {
            [theme.header_open]: hasVisibleTabContent,
          })}
        >
          {headerLeft}
          {title && <span className={theme.b__title}>{title}</span>}
          {buttons}
          {headerRight}
        </div>
      )}
      {children}
    </Container>
  );
};
