import React from 'react';
import { ToggleLayoutComponent } from './ToggleLayout.types';

export const ToggleLayout: ToggleLayoutComponent = ({
  theme,
  children,
  beforeContent,
  afterContent,
}) => {
  return (
    <span className={theme.button__content}>
      {beforeContent && <span className={theme.button__before}>{beforeContent}</span>}
      <span className={theme.button__text}>{children}</span>
      {afterContent && <span className={theme.button__after}>{afterContent}</span>}
    </span>
  );
};
