import Color from 'color';

export interface TagColorObj {
  bgColor: string;
  textColor: string;
  isShowBorder: boolean;
}

const store = new Map<string, TagColorObj>();

export const processColor = (str?: string): TagColorObj => {
  let formattedColorString: string;
  if (typeof str === 'string' && str) {
    if (!str.startsWith('#')) {
      formattedColorString = `#${str}`;
    } else {
      formattedColorString = str;
    }
  } else {
    formattedColorString = '#ffffff';
  }

  let result = store.get(formattedColorString);

  if (result) {
    return result;
  }

  let color = Color(formattedColorString);
  color = color.desaturate(0.1).lighten(0.2);

  result = {
    isShowBorder: color.luminosity() > 0.9,
    bgColor: color.rgb().toString(),
    textColor: color.isLight() ? '#000' : '#fff',
  };

  store.set(formattedColorString, result);

  return result;
};
