/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { ReactNode } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import Tag from 'lego/components/Tag';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './Tags.module.css';

export interface ComponentProps {
  className?: string;
  size?: LegoSizeProp;
  item?: any;
  onDelete?: (event: React.MouseEvent<HTMLButtonElement>) => void;
  render?: any;
  color?: string;
  disabled?: boolean;
}

export interface TagsProps {
  items?: any;
  onAdd?: (event: React.MouseEvent<HTMLButtonElement>) => void;
  injectAdd?: React.ReactNode;
  injectAfter?: React.ReactNode;
  size?: LegoSizeProp;
  buttonRef?: React.Ref<HTMLElement>;
  component?: React.ComponentType<ComponentProps>;
  getKey?: (item: any) => number | string;
  getColor?: (item: any) => string;
  onDelete?: (key: number | string, item: any) => void;
  onClick?: (key: number | string, item: any) => void;
  render?: any;
  theme?: 'link' | 'action' | 'clear' | 'default' | 'pseudo' | 'raised';
  className?: string;
  wrap?: 'wrap' | 'nowrap';
  placeholder?: string;
}

const Tags: React.FC<TagsProps> = (props) => {
  const {
    items,
    onAdd,
    injectAdd,
    injectAfter,
    size,
    buttonRef,
    component: Component = Tag,
    getKey = (item) => item,
    getColor,
    onDelete,
    onClick,
    render,
    theme = 'pseudo',
    wrap = 'wrap',
    className,
    placeholder,
  } = props;

  let content: ReactNode = null;

  if (Array.isArray(items) && items.length) {
    content = (
      <span className={cx(css.b__tags, css[`b__tags_${wrap}`])}>
        {items.map((item) => {
          const key = getKey(item);

          return (
            <Component
              className={css.b__tag}
              size={size}
              key={key}
              item={item}
              onClick={onClick ? () => onClick(key, item) : undefined}
              onDelete={
                onDelete
                  ? () => {
                      onDelete(key, item);
                    }
                  : undefined
              }
              render={render}
              color={getColor ? getColor(item) : item.color}
              disabled={item.disabled}
            >
              {item.name}
            </Component>
          );
        })}
        {injectAfter}
      </span>
    );
  } else if (placeholder) {
    content = <span className={css.b__placeholder}>{placeholder}</span>;
  }

  return (
    <span className={cx(className, css.b)}>
      {(onAdd || injectAdd) && (
        <span className={css.b__actions}>
          {onAdd && (
            <Button
              onClick={onAdd}
              size={size}
              ref={buttonRef}
              view={theme}
              icon={(iconCls) => <Icon className={iconCls} svg="add" />}
              data-testid="add-button"
            />
          )}
          {injectAdd}
        </span>
      )}
      {content}
    </span>
  );
};

export default Tags;
