import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Popup from '@crm/components/dist/lego2/Popup';
import Button from '@crm/components/dist/lego2/Button';
import NewTagModal from 'modules/tags/components/NewTagModal';
import Icon from 'lego/components/Icon';
import SetTagList from 'modules/tags/components/SetTagList';
import connectNewTagModal from 'modules/tags/containers/connectNewTagModal';
import { getTags } from 'modules/tags/actions';
import css from './styles.modules.scss';

/* hack for storybook
 * почему-то storybook импортирует NewTagModal как undefined
 * */
const RenderModal = connectNewTagModal(NewTagModal || (() => null));

class SetTag extends Component {
  constructor(props) {
    super(props);
    this.state = {
      popup: false,
      modal: false,
      tags: [],
    };
    this.node = React.createRef();
  }

  setTag = (item) => {
    this.props.onAdd(item.id, item);
    this.hidePopup();
  };

  showPopup = () => {
    const { type } = this.props;

    let promise;
    if (type) {
      promise = getTags({ type });
    } else {
      promise = this.props.loadTags();
    }

    promise.then((data) => {
      this.setState({
        tags: data && data.items,
        popup: true,
        modal: false,
      });
    });
  };

  hidePopup = () => {
    this.setState({ popup: false });
  };

  showModal = () => {
    this.setState({ modal: true, popup: false });
  };

  hideModal = () => {
    this.setState({ modal: false });
  };

  renderPopup() {
    return (
      <div className={css.popupContent}>
        <SetTagList className={css.list} tags={this.state.tags} onClick={this.setTag} />
        {this.props.canCreate && (
          <div className={css.addNew}>
            <Button size="xs" onClick={this.showModal} view="pseudo">
              Новая метка
            </Button>
          </div>
        )}
      </div>
    );
  }

  render() {
    const { type, formFields, className } = this.props;

    let initialValues;
    if (type) {
      initialValues = { type };
    }

    return (
      <React.Fragment>
        <Button
          className={className}
          size="xs"
          view="pseudo"
          innerRef={this.node}
          title="Добавить метку"
          onClick={this.showPopup}
          icon={(iconCls) => <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="add" />}
        />
        <Popup
          visible={this.state.popup}
          onClose={this.hidePopup}
          target="anchor"
          anchor={this.node}
          autoZIndex
          minZIndex={2003}
          directions="bottom"
        >
          {this.renderPopup()}
        </Popup>
        <RenderModal
          form="AddNewTag"
          fields={formFields}
          show={this.state.modal}
          onHide={this.hideModal}
          addTag={this.props.onAdd}
          initialValues={initialValues}
        />
      </React.Fragment>
    );
  }
}

// todo: add support placement

SetTag.propTypes = {
  className: PropTypes.string,
  type: PropTypes.string,
  loadTags: PropTypes.func,
  onAdd: PropTypes.func,
  canCreate: PropTypes.bool,
};

SetTag.defaultProps = {
  className: undefined,
  type: undefined,
  loadTags: () => {},
  onAdd: () => {},
  canCreate: true,
};

export default SetTag;
