import * as React from 'react';
import ArrayValueManager, { Value } from 'utils/ArrayValueManager';
import Tags from 'lego/components/Tags';
import AddTag from './AddTag';

interface Tag {
  id: number;
  name: string;
}

interface Props {
  value: Tag[];
  onChange: (value: Value) => void;
  loadTags?: () => Promise<Tag[]>;
}

class TagsContainer extends React.Component<Props> {
  private arrayValueManager = new ArrayValueManager();

  private handleAdd = (id, item) => {
    if (item) {
      this.updateValue(item, 'add');
    } else {
      this.updateValue(id, 'add');
    }
  };

  private handleRemove = (id, item) => {
    this.updateValue(item, 'remove');
  };

  private updateValue = (item, action: string) => {
    const { onChange, value } = this.props;

    if (typeof onChange === 'function') {
      this.arrayValueManager.set(value);
      onChange(this.arrayValueManager[action](item));
    }
  };

  public render() {
    const { value, loadTags, ...other } = this.props;

    return (
      <Tags
        injectAdd={
          <AddTag
            type={!loadTags ? 'Mail' : undefined}
            onAdd={this.handleAdd}
            loadTags={loadTags}
          />
        }
        onDelete={this.handleRemove}
        items={value}
        {...other}
      />
    );
  }
}

export default TagsContainer;
