/*
eslint-disable
react/prefer-stateless-function
*/

import React from 'react';
import PropTypes from 'prop-types';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import css from './TextInputWithButton.modules.scss';

class TextInputWithButton extends React.Component {
  static propTypes = {
    size: PropTypes.string,
    onClick: PropTypes.func,
    buttonLabel: PropTypes.string,
    children: PropTypes.node,
  };

  static defaultProps = {
    size: PropTypes.string,
    onClick: PropTypes.func,
    buttonLabel: PropTypes.string,
    children: PropTypes.node,
  };

  render() {
    const { size, onClick, buttonLabel, children, ...props } = this.props;

    return (
      <span className={css.TextInputWithButton}>
        <Textinput hasClear={false} size={size} {...props} pin="round-clear" />
        <Button size={size} onClick={onClick} pin="brick-round">
          {buttonLabel}
        </Button>
        {children}
      </span>
    );
  }
}

export default TextInputWithButton;
