import React, { Component } from 'react';
import PropTypes from 'prop-types';
import ComboInput from 'lego/components/ComboInput';
import TreePopup from './TreePopup';

class TreeInput extends Component {
  constructor(props) {
    super(props);

    this.state = { visible: false };
    this.input = React.createRef();
  }

  setAndHide = (...args) => {
    this.set(...args);
    this.hide();
  };

  clear = () => {
    this.props.onChange(null);
  };

  show = () => {
    this.setState({ visible: true });
  };

  hide = () => {
    this.setState({ visible: false });
  };

  toggle = () => {
    this.setState((state) => ({ visible: !state.visible }));
  };

  set = (id, item) => {
    this.props.onChange(item);
  };

  render() {
    const {
      className,
      size,
      value,
      name,
      endpoint,
      directions,
      getSlugId,
      canItemClick,
      placeholder,
      comboInputField = 'name',
      oId,
    } = this.props;
    const comboInputValue = (value && value[comboInputField]) || undefined;
    return (
      <React.Fragment>
        <ComboInput
          className={className}
          size={size}
          innerRef={this.input}
          value={comboInputValue}
          placeholder={placeholder}
          onChange={this.toggle}
          onClear={this.clear}
        />
        <TreePopup
          visible={this.state.visible}
          onCancel={this.hide}
          anchor={this.input}
          directions={directions}
          name={name}
          endpoint={endpoint}
          value={value}
          onClear={this.clear}
          onClick={this.setAndHide}
          getSlugId={getSlugId}
          canItemClick={canItemClick}
          oId={oId}
        />
      </React.Fragment>
    );
  }
}

TreeInput.propTypes = {
  name: PropTypes.string.isRequired,
  endpoint: PropTypes.string.isRequired,
  value: PropTypes.any, // eslint-disable-line
  className: PropTypes.string,
  size: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  directions: PropTypes.arrayOf(PropTypes.string),
  getSlugId: PropTypes.func,
  canItemClick: PropTypes.func,
  placeholder: PropTypes.node,
  oId: PropTypes.instanceOf(Object),
};

TreeInput.defaultProps = {
  value: undefined,
  className: undefined,
  size: undefined,
  directions: undefined,
  getSlugId: undefined,
  canItemClick: undefined,
  placeholder: undefined,
  oId: undefined,
};

export default TreeInput;
