import React from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import Tree from './Tree';

const TreePopup = (props) => {
  const {
    anchor,
    visible,
    value = {},
    endpoint,
    name,
    onCancel,
    directions,
    onClear,
    onClick,
    clearButton,
    nestedValue,
    getSlugId,
    canItemClick,
    oId,
  } = props;

  return (
    <Popup
      visible={visible}
      onOutsideClick={onCancel}
      target="anchor"
      anchor={anchor}
      directions={directions}
      padding="xs"
      autoZIndex
    >
      <Tree
        name={name}
        endpoint={endpoint}
        selected={value && value.id}
        onClear={onClear}
        onClick={onClick}
        clearButton={clearButton}
        nestedValue={nestedValue}
        destroyOnUnmount
        getSlugId={getSlugId}
        canItemClick={canItemClick}
        requestParams={oId ? { ...oId } : undefined}
      />
    </Popup>
  );
};

export default TreePopup;
