import React, { memo } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import Icon from 'lego/components/Icon';
import { getConfig } from './config';

const getPin = (length, index) => {
  if (length > 1) {
    if (index === 0) {
      return 'round-clear';
    }

    if (index === length - 1) {
      return 'brick-round';
    }
  }

  if (length === 1) {
    return 'round-round';
  }

  return 'brick-clear';
};

const renderIcon = (renderProps) =>
  typeof renderProps.icon === 'string' ? (
    <Icon pack="material" icon={renderProps.icon} className={renderProps.className} />
  ) : (
    <Icon {...renderProps.icon} className={renderProps.className} />
  );

const EditButtons = memo(({ onClick, theme, view, size, className }) => {
  const config = getConfig();

  const renderButton = (key, pin) => {
    const { icon, ...other } = config.buttons.map[key];

    return (
      <Button
        view={view}
        theme={theme}
        size={size}
        key={key}
        onClick={other.type !== 'link' ? (e) => onClick(e, key) : undefined}
        pin={pin}
        {...other}
        title={config.locales.ru[key]}
        icon={(iconCls) =>
          renderIcon({
            icon,
            className: iconCls,
          })
        }
      />
    );
  };

  const renderGroup = (items, index) => (
    <span key={index}>
      {items.map((key, index) => renderButton(key, getPin(items.length, index)))}
    </span>
  );

  return (
    <Toolbar className={className}>
      {config.buttons.list.map((buttons, index) => renderGroup(buttons, index))}
    </Toolbar>
  );
});

export default EditButtons;
