import React from 'react';
import Textarea from '@crm/components/dist/lego2/Textarea';
import cx from 'classnames';
import { getConfig } from './config';
import EditButtons from './EditButtons';
import macroProcess from './macroProcess';
import css from './WFInput.module.css';

class WFInput extends React.Component {
  static defaultProps = {
    view: 'default',
  };

  getRef = (node) => {
    this.ref = node;
  };

  handleClick = (e, key) => {
    const config = getConfig();
    macroProcess(this.ref, config.macros[key]);
  };

  reply = (text) => {
    const config = getConfig();
    macroProcess(this.ref, { ...config.macros.reply, placeholder: text });
  };

  render() {
    const {
      className,
      afterButtonsPlaceholder,
      bottomButtonsPlaceholder,
      hidden,
      view,
      ...other
    } = this.props;

    return (
      <div className={cx(className, css[`b_view_${view}`])} hidden={hidden}>
        <div className={css.b__toolbar}>
          <div className={css.b__toolbarWrap}>
            <EditButtons onClick={this.handleClick} view="pseudo" className={css.b__buttons} />
            {afterButtonsPlaceholder && (
              <div className={css.b__right}>{afterButtonsPlaceholder}</div>
            )}
          </div>
          {bottomButtonsPlaceholder && (
            <div className={css.b__toolbarContent}>{bottomButtonsPlaceholder}</div>
          )}
        </div>
        <Textarea
          controlRef={this.getRef}
          isEventValue={false}
          className={css.b__input}
          {...other}
        />
      </div>
    );
  }
}

export default WFInput;
