import { config } from 'services/Config';

export const defaultConfig = {
  buttons: {
    list: [
      ['bold', 'italic', 'strikethrough', 'underline', 'color'],
      ['list_dot', 'list_number'],
      ['indent', 'outdent'],
      ['quote', 'link', 'img', 'code', 'table', 'scissor'],
      ['help'],
    ],
    map: {
      bold: {
        icon: 'format_bold',
      },
      italic: {
        icon: 'format_italic',
      },
      strikethrough: {
        icon: 'format_strikethrough',
      },
      underline: {
        icon: 'format_underlined',
      },
      color: {
        icon: 'format_color_text',
      },
      list_dot: {
        icon: 'format_list_bulleted',
      },
      list_number: {
        icon: 'format_list_numbered',
      },
      indent: {
        icon: 'format_indent_decrease',
      },
      outdent: {
        icon: 'format_indent_increase',
      },
      quote: {
        icon: 'format_quote',
      },
      link: {
        icon: 'insert_link',
      },
      img: {
        icon: 'insert_photo',
      },
      code: {
        icon: 'code',
      },
      table: {
        icon: 'grid_on',
      },
      scissor: {
        icon: {
          icon: 'scissors',
          pack: 'fontawesome',
        },
      },
      help: {
        theme: 'link',
        type: 'link',
        icon: 'help',
        url: 'https://wiki.yandex-team.ru/wiki/vodstvo/syntax/',
        target: '_blank',
      },
    },
  },
  locales: {
    ru: {
      help: 'Помощь',
      scissor: 'Врезка',
      table: 'Таблица',
      code: 'Код',
      img: 'Изображение',
      link: 'Ссылка',
      quote: 'Цитата',
      outdent: 'Отступ справа',
      indent: 'Отступ слева',
      list_number: 'Нумерованный список',
      list_dot: 'Маркированный список',
      color: 'Цветной текст',
      underline: 'Подчеркнутый',
      strikethrough: 'Перечеркнутый',
      italic: 'Курсив',
      bold: 'Жирный',
    },
    en: {
      help: 'Help',
      scissor: 'Cut',
      table: 'Table',
      code: 'Code',
      img: 'Image',
      link: 'Link',
      quote: 'Quote',
      outdent: 'Outdent',
      indent: 'Indent',
      list_number: 'Ordered list',
      list_dot: 'Unsorted list',
      color: 'Color text',
      underline: 'Underlined',
      strikethrough: 'Strikethrough',
      italic: 'Italic',
      bold: 'Bold',
    },
  },
  macros: {
    bold: {
      start: '**',
      end: '**',
      placeholder: 'Bold',
      mode: 'inline',
    },
    italic: {
      start: '//',
      end: '//',
      placeholder: 'Italic',
      mode: 'inline',
    },
    strikethrough: {
      start: '--',
      end: '--',
      placeholder: 'Strikethrough',
      mode: 'inline',
    },
    underline: {
      start: '__',
      end: '__',
      placeholder: 'Underlined',
      mode: 'inline',
    },
    color: {
      start: '!!',
      end: '!!',
      placeholder: 'Color text',
      mode: 'inline',
    },
    list_dot: {
      start: '* ',
      end: '',
      placeholder: 'Unordered List',
      mode: 'multiline',
    },
    list_number: {
      start: '1. ',
      end: '',
      placeholder: 'Ordered list',
      mode: 'multiline',
    },
    indent: {
      regexpStart: '\\s{1,2}',
      start: '',
      end: '',
      placeholder: '',
      mode: 'multiline',
    },
    outdent: {
      start: '  ',
      end: '',
      placeholder: '',
      mode: 'multiline',
    },
    quote: {
      start: '<[',
      end: ']>',
      placeholder: 'Quote',
      mode: 'inline',
    },
    reply: {
      start: '<[',
      end: ']>\n',
      placeholder: 'Quote',
      mode: 'insertToEnd',
    },
    link: {
      start: '((',
      end: '))',
      placeholder: 'Link',
      mode: 'inline',
    },
    img: {
      placeholder: 'widthxheight:link',
      mode: 'insert',
    },
    code: {
      placeholder: '%%(syntax)\ncode\n%%',
      mode: 'insert',
    },
    table: {
      placeholder: '\n#|\n|| cell text| cell text||\n|| cell text| cell text||\n|#\n',
      mode: 'insert',
    },
    scissor: {
      start: '<{',
      end: '}>',
      mode: 'inline',
      placeholder: 'Cut',
    },
  },
};

export const getConfig = () => {
  if (config.value.features.useYfm) {
    return {
      ...defaultConfig,
      macros: {
        ...defaultConfig.macros,
        underline: {
          ...defaultConfig.macros.underline,
          start: '++',
          end: '++',
        },
      },
    };
  }

  return defaultConfig;
};

export default defaultConfig;
