const modes = {
  // bold, italic
  inline: (text = '', macro, startPos, endPos) => {
    let selectedText = text.substring(startPos, endPos);
    if (!selectedText) {
      selectedText = macro.placeholder;
    }

    const value = `${macro.start}${selectedText}${macro.end}`;

    const rangeStart = startPos + macro.start.length;
    return { value, range: [rangeStart, rangeStart + selectedText.length] };
  },
  // lists, indent
  multiline: (text = '', macro, startPos, endPos) => {
    const afterFirstNewLineIndex = text.lastIndexOf('\n', startPos) + 1;

    let str = `\n${text.substring(afterFirstNewLineIndex, endPos)}`;

    const regexp = macro.regexpStart ? new RegExp(`\n${macro.regexpStart}`, 'g') : /\n/g;

    str = str.replace(regexp, `\n${macro.start}`);

    str = str.substring(1);

    return {
      value: str,
      rangeBeforeInsert: [afterFirstNewLineIndex, endPos],
      range: [afterFirstNewLineIndex, afterFirstNewLineIndex + str.length],
    };
  },
  // table, link
  insert: (_, macro, startPos, endPos) => ({
    value: macro.placeholder,
    rangeBeforeInsert: [endPos, endPos],
    range: [endPos, endPos],
  }),
  insertToEnd: (text, macro) => {
    const addText = `${text.length ? '\n\n' : ''}${macro.start || ''}${
      macro.placeholder
    }${macro.end || ''}`;
    const beforeInsertIndex = text.length;
    const afterInsertIndex = beforeInsertIndex + addText.length;

    return {
      value: addText,
      rangeBeforeInsert: [text.length, text.length],
      range: [afterInsertIndex, afterInsertIndex],
    };
  },
  // without support range
  simple: (text, macro) => ({
    value: `${text}${macro.start || ''}${macro.placeholder}${macro.end || ''}`,
    range: null,
  }),
};

const insertMacro = (text = '', macro, startPos, endPos) => {
  const mode = startPos != null ? macro.mode : 'simple';
  return modes[mode](text, macro, startPos, endPos);
};

export const insertMacroByRef = (ref, macro) => {
  ref.focus();

  const result = insertMacro(ref.value, macro, ref.selectionStart, ref.selectionEnd);

  if (result.rangeBeforeInsert) {
    ref.setSelectionRange(...result.rangeBeforeInsert);
  }

  const isSuccess = document.execCommand('insertText', false, result.value);

  /* fallback insert for firefox */
  if (!isSuccess && ref.setRangeText) {
    ref.setRangeText(result.value);

    const e = document.createEvent('UIEvent');
    e.initEvent('input', true, false);
    ref.dispatchEvent(e);
  }

  if (result.range) {
    window.setTimeout(() => {
      ref.setSelectionRange(...result.range);
    }, 0);
  }
};

export default insertMacroByRef;
