import { get } from 'api/common';
import { OId } from 'types';
import Promise from 'bluebird';

export type ProviderFunc = (text?: string, oId?: OId) => any;
export type ProviderUrl = string;
export type ProviderTypes = ProviderFunc | ProviderUrl;

export default class Provider {
  private cache: ProviderFunc;

  private delay = 0;

  public parse(provider: ProviderFunc | ProviderUrl) {
    if (this.cache) {
      return this.cache;
    }

    if (typeof provider === 'string') {
      this.cache = (text?: string, oId?: OId) =>
        Promise.delay(this.delay)
          .then(() => {
            this.delay = 300;
            return get({ url: provider, data: { text, ...oId } });
          })
          .then(response => {
            this.delay = 0;
            return response;
          });
      return this.cache;
    }

    return provider;
  }
}
