import * as React from 'react';
import get from 'lodash/get';
import {
  AttachFilesWithApi,
  BackendResponse,
  AttachFilesWithApiProps,
} from 'lego/components/AttachFiles';
import { FormSpy, FormSpyRenderProps, FieldRenderProps } from 'react-final-form';
import { FormApi } from 'final-form';
import withFinalFormField from './withFinalFormField';

type Props = AttachFilesWithApiProps &
  FieldRenderProps<BackendResponse> & {
    onChange: (payload: BackendResponse) => void;
  };

const subscription = {};

class AttachFiles extends React.Component<Props> {
  private formApi: FormApi;

  private handleChange = (data: BackendResponse) => {
    if (!data.files) {
      return;
    }

    this.formApi.batch(() => {
      this.formApi.change(this.props.name, data);
      this.formApi.change('containerId', data.containerId);
    });
  };

  public renderSpy = (props: FormSpyRenderProps) => {
    let files = get(this.props, 'value.files');
    // TODO: https://st.yandex-team.ru/CRM-10614
    const containerId =
      get(this.props, 'value.containerId') || get(props.form.getState().values, 'containerId');
    const { objId, fileInputRef: outerFileInputRef, ...other } = this.props;
    const fileInputRef =
      outerFileInputRef && outerFileInputRef.asCallback
        ? outerFileInputRef.asCallback
        : outerFileInputRef;

    if (Array.isArray(this.props.value)) {
      files = this.props.value;
    }

    this.formApi = props.form;
    return (
      <AttachFilesWithApi
        {...other}
        ref={fileInputRef}
        files={files}
        containerId={containerId}
        objId={objId}
        onChange={this.handleChange}
      />
    );
  };

  public render() {
    return <FormSpy subscription={subscription}>{this.renderSpy}</FormSpy>;
  }
}

export default withFinalFormField()(AttachFiles);
