import React from 'react';
import { FieldRenderProps } from 'react-final-form';
import Editor, { EditorRef } from 'components/RichHtmlEditor';
import { MergeRef } from 'utils/mergeRef';

export default class RichTextEditor extends React.Component<FieldRenderProps<string>> {
  private editorRef = new MergeRef<EditorRef>();

  public get ckeditor() {
    if (!this.editorRef.current) {
      return null;
    }

    return this.editorRef.current;
  }

  handleBlur = (text: string) => {
    const syntheticEvent: unknown = { target: { value: text } };
    this.props.input.onBlur(syntheticEvent as React.FocusEvent<HTMLElement>);
  };

  public render() {
    const {
      input,
      label,
      meta: { initial },
      className,
      size,
      enableReinitialize,
      ckeditorRef,
      ...custom
    } = this.props;

    this.editorRef.refs = [ckeditorRef];

    return (
      <Editor
        defaultValue={enableReinitialize ? initial : undefined}
        className={className}
        ckeditorRef={this.editorRef}
        {...input}
        {...custom}
        onBlur={this.handleBlur}
      />
    );
  }
}
