import React from 'react';
import { config } from 'services/Config';
import { TreeInput } from 'components/TreeInput';
import withFinalFormField from './withFinalFormField';
import TreeInputOld from '../components/TreeInput';

const treeAdapter = (data) => {
  return data?.map(({ id, fullName, name, items, ids }) => ({
    id,
    data: {
      label: name,
      fullPath: fullName,
      ids,
    },
    items: treeAdapter(items),
  }));
};

const TreeInputWithAdapter: typeof TreeInput = (props) => {
  if (!config.value.features.newDesignLift) return <TreeInputOld {...props} />;

  const onChange = (value) => {
    if (!value) {
      props.onChange(null);
      return;
    }

    const { id, data } = value;
    props.onChange({ id, ...data, name: data.label });
  };

  return <TreeInput {...props} onChange={onChange} treeAdapter={treeAdapter} />;
};

export interface Props {
  endpoint?: string;
}

export default withFinalFormField<Props>({ isTouchOnChange: true })(TreeInputWithAdapter);
