import * as React from 'react';

interface ContextField {
  setAsync: (flag: boolean) => void;
}

interface State {
  async: boolean;
}

export const AsyncFieldContext = React.createContext<ContextField>({ setAsync: () => {} });
export const AsyncFormContext = React.createContext<boolean>(false);

export const withAsyncFieldProvider = () => WrappedComponent => {
  const WithAsyncFieldProvider = React.forwardRef((props, ref) => (
    <AsyncFieldProvider>
      <WrappedComponent {...props} ref={ref} />
    </AsyncFieldProvider>
  ));

  return WithAsyncFieldProvider;
};

export default class AsyncFieldProvider extends React.Component<{}, State> {
  public state = { async: false };

  private childContext: { setAsync: (flag: boolean) => void };

  public constructor(props) {
    super(props);

    this.state = { async: false };
    this.childContext = { setAsync: this.setAsync };
  }

  public setAsync = (flag: boolean) => {
    this.setState({ async: flag });
  };

  public render() {
    const { children } = this.props;
    const { async } = this.state;

    return (
      <AsyncFieldContext.Provider value={this.childContext}>
        <AsyncFormContext.Provider value={async}>{children}</AsyncFormContext.Provider>
      </AsyncFieldContext.Provider>
    );
  }
}
