/*
eslint-disable react/no-multi-comp
*/

import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import hoistNonReactStatic from 'hoist-non-react-statics';
import { withModal, toggle } from 'containers/Modal';
import Modal from '@crm/components/dist/lego2/Modal';

const WithReduxModal = withModal(Modal);

const mapDispatch = (dispatch, props) => ({
  onCancel: () => {
    if (typeof props.onCancel === 'function') {
      props.onCancel();
    }
    return dispatch(toggle(props.name, false));
  },
  dispatch,
});

const withModalForm = (settings) => (WrappedComponent) => {
  class ModalForm extends React.Component {
    static propTypes = {
      onSubmitSuccess: PropTypes.func,
      dispatch: PropTypes.func.isRequired,
      children: PropTypes.func,
      name: PropTypes.oneOfType([PropTypes.number, PropTypes.string]).isRequired,
      size: PropTypes.oneOfType([PropTypes.number, PropTypes.string, PropTypes.func]),
      modalProps: PropTypes.instanceOf(Object),
      formProps: PropTypes.instanceOf(Object),
    };

    static defaultProps = {
      onSubmitSuccess: undefined,
      children: undefined,
      size: undefined,
      modalProps: undefined,
      formProps: undefined,
    };

    onSubmitSuccess = (...args) => {
      if (typeof this.props.onSubmitSuccess === 'function') {
        this.props.onSubmitSuccess(...args);
      }

      this.close();
    };

    open = () => {
      this.props.dispatch(toggle(this.props.name, true));
    };

    close = () => {
      this.props.dispatch(toggle(this.props.name, false));
    };

    renderModal() {
      const { name, size, modalProps, onSubmitSuccess, formProps, ...props } = this.props;

      let computedSize = size;
      if (typeof size === 'function') {
        computedSize = size(this.props);
      }

      return (
        <WithReduxModal name={name} size={computedSize} {...modalProps}>
          <WrappedComponent
            name={name}
            form={name}
            {...formProps}
            {...props}
            onSubmitSuccess={this.onSubmitSuccess}
          />
        </WithReduxModal>
      );
    }

    // need remove null form children(null, ...)
    // null was modal element
    render() {
      const { children } = this.props;
      const modal = this.renderModal();

      if (typeof children === 'function') {
        return (
          <React.Fragment>
            {children(null, this.open)}
            {modal}
          </React.Fragment>
        );
      }

      return modal;
    }
  }

  const ConnectedModalForm = connect(null, mapDispatch, undefined, { forwardRef: true })(ModalForm);
  hoistNonReactStatic(ConnectedModalForm, WrappedComponent);
  ConnectedModalForm.defaultProps = {
    ...settings,
  };

  // build outer component to expose instance api
  return class ReduxModal extends React.Component {
    open() {
      this.wrapped.open();
    }

    close() {
      this.wrapped.close();
    }

    render() {
      return (
        <ConnectedModalForm
          {...this.props}
          ref={(wrapped) => {
            this.wrapped = wrapped;
          }}
        />
      );
    }
  };
};

export default withModalForm;
