import * as React from 'react';
import { connect } from 'react-redux';
import { change, WrappedFieldProps, getFormValues } from 'redux-form';
import { AttachFilesWithApi, BackendResponse } from 'lego/components/AttachFiles';

const CONTAINER_ID = 'containerId';

export { AttachFilesWithApi };

type Props = WrappedFieldProps & { props?: any; refComponent?: React.Ref<AttachFilesWithApi> };

class RenderAttachFiles extends React.Component<Props> {
  private handleChange = (data: BackendResponse) => {
    const { input, meta } = this.props;
    const { onChange } = input;
    const { dispatch, form } = meta;

    dispatch(change(form, CONTAINER_ID, data.containerId));
    onChange(data.files);
  };

  public render() {
    const { props, input, refComponent, ...other } = this.props;

    return (
      <AttachFilesWithApi
        {...other}
        {...props}
        ref={refComponent}
        files={this.props.input.value}
        onChange={this.handleChange}
      />
    );
  }
}

export default connect<{ containerId?: number }, {}, Props>((state, props) => {
  const values = getFormValues(props.meta.form)(state) || {};

  return {
    [CONTAINER_ID]: values[CONTAINER_ID],
  };
})(RenderAttachFiles);
