import React from 'react';
import Editor from 'components/RichHtmlEditor';
import { MergeRef } from 'utils/mergeRef';

export default class RichTextEditor extends React.Component {
  editorRef = new MergeRef();

  get ckeditor() {
    return this.editorRef.current;
  }

  render() {
    const {
      input,
      label,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars, no-unused-vars
      meta: { touched, error, active, initial },
      className,
      size,
      enableReinitialize,
      ckeditorRef,
      ...custom
    } = this.props;

    this.editorRef.refs = [ckeditorRef];

    return (
      <Editor
        defaultValue={enableReinitialize ? initial : undefined}
        className={className}
        ckeditorRef={this.editorRef}
        {...input}
        {...custom}
      />
    );
  }
}
