import React from 'react';
import { Tag } from 'types';
import SetTag from 'modules/tags/components/SetTag';

export default ({ input: { value = [], onChange }, tagsType }) => {
  const currentValue: Tag[] = Array.isArray(value) ? value : [];
  const handleAdd = (tag) => {
    if (!currentValue.some((item) => item.id === tag.id)) {
      const newValue = [...currentValue, tag];
      onChange(newValue);
    }
  };
  return (
    <span style={{ padding: '4px' }}>
      <SetTag type={tagsType} addTag={handleAdd} canCreate={false} />
      <span>Добавить метку</span>
    </span>
  );
};
