import React from 'react';
import { Tag } from 'types';
import Tags from 'modules/tags/components/Tags';

export default ({ input: { value = [] as Tag[], onChange } }) => {
  const removeTag = (id) => {
    const newValue = value.filter((tag) => tag.id !== id);
    onChange(newValue);
  };
  return (
    <div style={{ padding: '4px 0' }}>
      <Tags canEdit={false} tags={value} onDelete={removeTag} />
    </div>
  );
};
