import React, { FC } from 'react';
import { Field } from 'redux-form';
import Textinput from '../TextInput';
import { TextRangeProps } from './TextRange.types';
import css from './TextRange.module.css';

export const TextRange: FC<TextRangeProps> = (props) => {
  const { startName, startPlaceholder = 'с', endName, endPlaceholder = 'по', label } = props;

  return (
    <div className={css.TextRange}>
      {label && <div className={css.TextRange__title}>{label}</div>}
      <Field
        name={startName}
        label="с"
        component={Textinput}
        size="xs"
        placeholder={startPlaceholder}
      />
      &mdash;
      <Field
        name={endName}
        label="по"
        component={Textinput}
        size="xs"
        placeholder={endPlaceholder}
      />
    </div>
  );
};
