import * as React from 'react';

interface Props {
  input: any;
  children: (props: any) => React.ReactNode;
}

class ToggleInput extends React.Component<Props> {
  handleChange = () => {
    const {
      input: { onChange, value },
    } = this.props;

    onChange(!value);
  };

  render() {
    const {
      input: { value },
      children,
    } = this.props;

    return children({ value, onChange: this.handleChange });
  }
}

export default ToggleInput;
