import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import FilterTreeView from 'containers/TreeSelect/FilterTreeView';
import connectorTreeView from 'containers/TreeSelect/connectorTreeView';
import get from 'lodash/get';

const spanStyles = {
  minWidth: 0,
  flex: 1,
  overflow: 'hidden',
  textOverflow: 'ellipsis',
};

const TreeContainer = connectorTreeView({
  mode: connectorTreeView.MODE.HIERARCHY_CHECK,
  toggleButtons: true,
  clearButton: true,
})(FilterTreeView);

export default class TreeInput extends React.Component {
  handleOnChange = (...args) => {
    this.props.input.onChange(...args);
    if (this.props.mode === 'radio') {
      this.hidePopup();
    }
  };

  toggle = () => {
    const {
      size,
      displayKeySlug,
      input: { value },
      labelPrefix,
      labelWidth,
      defaultValueText,
    } = this.props;

    const selectedFolderName = get(value, `selectedItem.${displayKeySlug}`);
    const count = get(value, 'selectedArray.length');

    return (
      <Button
        size={size}
        width="max"
        iconRight={(iconCls) => <Icon className={iconCls} type="arrow" direction="bottom" />}
      >
        {labelPrefix && (
          <span style={{ color: 'grey', width: labelWidth, textAlign: 'left' }}>{labelPrefix}</span>
        )}
        <span style={spanStyles}>
          {selectedFolderName || (count && `Выбрано ${count}`) || defaultValueText}
        </span>
      </Button>
    );
  };

  content = (popupBag) => {
    const {
      mode,
      name,
      endpoint,
      backendDataType,
      getSlugId,
      canItemClick,
      input: { value },
      className,
    } = this.props;

    this.hidePopup = popupBag.hide;

    return (
      <TreeContainer
        className={className}
        autoFocus
        onChange={this.handleOnChange}
        mode={mode}
        name={name}
        endpoint={endpoint}
        backendDataType={backendDataType}
        getSlugId={getSlugId}
        canItemClick={canItemClick}
        selected={value}
        destroyOnUnmount
        nestedValue
      />
    );
  };

  render() {
    return (
      <ImperativePopup
        content={this.content}
        toggle={this.toggle}
        directions="bottom"
        padding="xs"
        zIndex={100}
      />
    );
  }
}

TreeInput.propTypes = {
  input: PropTypes.instanceOf(Object).isRequired,
  displayKeySlug: PropTypes.string,
  mode: PropTypes.string,
  name: PropTypes.string,
  size: PropTypes.string,
  backendDataType: PropTypes.string,
  endpoint: PropTypes.string,
  labelWidth: PropTypes.string,
  labelPrefix: PropTypes.string,
  defaultValueText: PropTypes.string,
  canItemClick: PropTypes.func,
  getSlugId: PropTypes.func,
  className: PropTypes.string,
};

TreeInput.defaultProps = {
  size: 's',
  name: 'FOLDERS',
  endpoint: '/view/mail/folder/list',
  defaultValueText: '',
  displayKeySlug: 'name',
  labelPrefix: null,
  labelWidth: undefined,
  mode: undefined,
  backendDataType: undefined,
  getSlugId: undefined,
  canItemClick: undefined,
  className: undefined,
};
