interface Mods {
  [key: string]: string | boolean;
}

export interface Mix {
  block: string;
  elem?: string;
  mods?: Mods;
}

export default (mixs?: (Mix | undefined)[]): string => {
  if (!Array.isArray(mixs)) {
    return '';
  }

  return mixs
    .map(mix => {
      if (!mix) {
        return '';
      }

      let result = mix.block;

      if (mix.elem) {
        result += `__${mix.elem}`;
      }

      if (mix.mods) {
        const { mods } = mix;
        result = Object.keys(mods)
          .map(key => {
            const value = mods[key];

            if (typeof value === 'boolean') {
              return `${result}_${key}`;
            }

            return `${result}_${key}_${value}`;
          })
          .join(' ');
      }

      return result;
    })
    .join(' ');
};
