import React from 'react';

export class ModalContainer extends React.Component {
  public static instance?: ModalContainer;

  private contentMap = new Map<string, React.ReactNode>();

  public constructor(props) {
    super(props);

    ModalContainer.instance = this;
  }

  public setContent(key: string, content: React.ReactNode) {
    this.contentMap.set(key, content);
    this.forceUpdate();
  }

  public removeContentByKey(key: string) {
    this.contentMap.delete(key);
    this.forceUpdate();
  }

  public render() {
    const content: React.ReactNode[] = [];

    /* eslint-disable-next-line no-restricted-syntax */
    for (const [key, value] of this.contentMap) {
      content.push(<React.Fragment key={key}>{value}</React.Fragment>);
    }

    return content;
  }
}
