import React from 'react';
import { storiesOf } from '@storybook/react';
import Button from '@crm/components/dist/lego2/Button';
import { ModalForm } from './ModalForm';
import { ModalFormProps } from './ModalForm.types';
import { ModalContainer } from './ModalContainer';

interface FormProps extends ModalFormProps {
  title: string;
}

const Form2: React.FC<FormProps & ModalFormProps> = ({ onCancel, title }) => (
  <div>
    <div>{title}</div>
    <Button onClick={onCancel}>close</Button>
  </div>
);

const modalForm2 = new ModalForm<FormProps>('form1', Form2);

const Form1: React.FC<FormProps & ModalFormProps> = ({ onSubmitSuccess, onCancel, title }) => (
  <div>
    <div>{title}</div>
    <div>
      <Button onClick={() => modalForm2.open({ title: 'new form 2' })}>open form 2</Button>
    </div>
    <Button onClick={onSubmitSuccess}>submit</Button>
    <Button onClick={onCancel}>close</Button>
  </div>
);

const modalForm1 = new ModalForm<FormProps>('form2', Form1);

storiesOf('Modal Form', module).add('simple', () => (
  <div>
    <Button onClick={() => modalForm1.open({ title: 'new form 1' })}>open modal</Button>
    <ModalContainer />
  </div>
));
