import { ModalViewProps } from 'types/ModalService';

export interface ModalProps {
  size?: string;
  hasAnimation?: boolean;
  canMinimize?: boolean;
  keepMounted?: boolean;
  "data-testid"?: string;
}

export type ModalFormProps = Partial<ModalViewProps>;

export type FormComponentType<P> = React.ComponentType<P>;

export interface ModalFormOptions<P extends ModalFormProps> {
  key: string;
  formComponent: FormComponentType<P>;
  modalProps?: ModalProps;
  formProps?: Partial<P>;
  onLoad?: (props: P) => Promise<unknown>;
}
