import React from 'react';
import Modal from '@crm/components/dist/lego2/Modal';
import { observer } from 'mobx-react-lite';
import { ReactModalFormProps } from './ReactModalForm.types';
import { ModalFormProps, ModalProps } from '../ModalForm.types';

export const ReactModalForm = observer(
  <P extends ModalFormProps>(
    props: ReactModalFormProps<P> & { formProps: P; modalProps?: ModalProps },
  ) => {
    const { formComponent: FormComponent, formProps, modalProps, onClose, modalService } = props;

    const handleClose = () => {
      onClose?.();

      if (formProps?.onClose) {
        formProps.onClose();
      }
    };

    const handleSubmitSuccess = (...args) => {
      onClose?.();

      if (formProps?.onSubmitSuccess) {
        formProps.onSubmitSuccess(...args);
      }
    };

    return (
      <Modal
        visible={modalService.isVisible && !modalService.isMinimized}
        onClose={handleClose}
        onMinimize={modalProps?.canMinimize ? modalService.minimize : undefined}
        keepMounted={modalService.isMinimized}
        {...modalProps}
      >
        <FormComponent
          onCancel={handleClose}
          {...formProps}
          onSubmitSuccess={handleSubmitSuccess}
        />
      </Modal>
    );
  },
);
