import React, { useState } from 'react';
import { MoneyValue } from 'types/api/form/Fields/Money';
import { Money } from './Money';

export default {
  title: 'lego2/Money',
};

export const Default = () => {
  const [value, handleChange] = useState<MoneyValue>({
    value: 100500,
    currency: {
      code: 'USD',
      id: 2,
      name: 'дол.',
    },
  });

  return (
    <Money
      value={value}
      onChange={handleChange}
      currency={[
        {
          code: 'RUB',
          id: 0,
          name: 'руб.',
        },
        {
          code: 'TNG',
          id: 1,
          name: 'тенге',
        },
        {
          code: 'USD',
          id: 2,
          name: 'дол.',
        },
      ]}
    />
  );
};
