import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Select, { Option } from '@crm/components/dist/lego2/Select';
import cx from 'classnames';
import { MoneyProps } from './Money.types';
import css from './Money.module.css';

export class Money extends React.Component<MoneyProps> {
  private handleChangeText = (value: string) => {
    if (this.props.onChange) {
      this.props.onChange({ ...this.props.value, value: Number(value) });
    }
  };

  private handleChangeCurrency = (value: string) => {
    if (this.props.onChange) {
      this.props.onChange({
        ...this.props.value,
        currency: this.props.currency.find((item) => item.id === Number(value)),
      });
    }
  };

  private getCurrencyOptions = (): Option[] => {
    const { currency } = this.props;

    return currency.map((item) => ({
      value: String(item.id),
      content: item.name,
    }));
  };

  render() {
    const { value = {}, size, className } = this.props;
    const { value: textInputValue, currency: selectValue } = value;
    const bodyRef: React.RefObject<HTMLElement> = { current: document.body };

    return (
      <span className={cx(className, css.Money)}>
        <Textinput
          className={css.Money__value}
          onChange={this.handleChangeText}
          type="number"
          value={String(textInputValue)}
          hasClear={false}
          size={size}
        />
        <Select
          onChange={this.handleChangeCurrency}
          options={this.getCurrencyOptions()}
          value={selectValue && String(selectValue.id)}
          size={size}
          hasEmptyValue={false}
          unsafe_scope={bodyRef}
        />
      </span>
    );
  }
}
