export default {
  updaters: {},

  /**
   * @param {Updater} updater - updater
   * */
  addUpdate(updater) {
    if (!Array.isArray(this.updaters[updater.context])) {
      this.updaters[updater.context] = [];
    }

    this.updaters[updater.context].push(updater);
  },

  /**
   * @param {Updater} updater - updater
   * */
  removeUpdate(updater) {
    this.updaters[updater.context] =
      this.updaters[updater.context].filter(item => (item.key !== updater.key));
  },

  update(context, updateJSON, dispatch, state) {
    const list = this.updaters[context];

    if (list && list.length) {
      list.forEach((updater) => { updater.update(updateJSON[updater.key], dispatch, state); });
    }
  },

  getContextArgs(context, state = {}) {
    const list = this.updaters[context];

    if (list && list.length) {
      const contextArgs = {};

      if (list && list.length) {
        list.forEach((updater) => { contextArgs[updater.key] = updater.getContextArgs(state); });
      }

      return contextArgs;
    }

    return null;
  },
};

/**
 * @typedef {Object} Updater
 * @property {string} context
 * @property {string} key
 * @property {function} getContextArgs
 * @property {function} update
 * */
