const middleware = store => next => action => {
  if (action.type !== 'PROMISE') {
    return next(action);
  }

  const [REQUEST, RECEIVE, FAIL] = action.actions || [];

  if (REQUEST) {
    store.dispatch({ type: REQUEST, meta: action.meta });
  }
  return action.promise
    .then(data => {
      if (RECEIVE) {
        let dispatchedAction = {
          type: RECEIVE,
          data,
          args: action.args,
          meta: action.meta,
        };

        if (action.decorate && action.decorate.success) {
          dispatchedAction = action.decorate.success(dispatchedAction);
        }

        store.dispatch(dispatchedAction);
      }

      return data;
    })
    .catch(error => {
      if (FAIL) {
        let dispatchedAction = { type: FAIL, error, meta: action.meta };

        if (action.decorate && action.decorate.fail) {
          dispatchedAction = action.decorate.fail(dispatchedAction);
        }

        store.dispatch(dispatchedAction);
      }

      throw error;
    });
};

export default middleware;
