import RWS from '@khromkov/rws';

export const TYPE = 'WEBSOCKET';
export const CREATE = 'WEBSOCKET/CREATE';
export const MESSAGE = 'WEBSOCKET/MESSAGE';
export const CLOSE = 'WEBSOCKET/CLOSE';
export const SEND = 'WEBSOCKET/SEND';

export const websockets = {};

const onopen = () => {
  console.log('Соединение установлено.');
};

const onerror = error => {
  console.log(`Ошибка ${error.message}`);
};

export default store => next => action => {
  const { type, name, url, data } = action;
  if (typeof type === 'string' && type.startsWith(TYPE)) {
    if (!name && type !== MESSAGE) {
      console.error('WEBSOCKET: name is undefined');
    } else {
      if (type === CREATE) {
        if (websockets[name]) {
          console.error('WEBSOCKET: EXIST');
        } else if (!url) {
          console.error('WEBSOCKET: url is undefined');
        } else {
          const { message } = action;
          const socket = new RWS(url, undefined, {
            shouldReconnect(event) {
              return event.code !== 1000;
            },
          });
          socket.addEventListener('open', onopen);
          socket.addEventListener('close', event => {
            if (event.wasClean) {
              console.log('Соединение закрыто чисто');
            } else {
              console.log('Обрыв соединения'); // например, "убит" процесс сервера
            }

            store.dispatch({
              type: CLOSE,
              meta: {
                name,
              },
              data: {
                code: event.code,
                reason: event.reason,
              },
            });
          });
          socket.addEventListener('message', event => {
            let messageData = event.data;
            try {
              messageData = JSON.parse(event.data);
            } catch (e) {
              // empty
            }

            if (typeof message === 'function') {
              message(store)(messageData);
            }

            store.dispatch({
              type: MESSAGE,
              meta: {
                name,
              },
              data: messageData,
            });
          });
          socket.addEventListener('error', onerror);
          websockets[name] = socket;
        }
      }

      if (type === SEND) {
        const socket = websockets[name];
        if (socket) {
          let jsonData;
          try {
            jsonData = JSON.stringify(data);
          } catch (e) {
            /* emtpy */
          }
          if (jsonData) {
            socket.send(jsonData);
          }
        }
      }
    }
  }

  return next(action);
};
