import React from 'react';
import { Route, Switch } from 'react-router-dom';
import Authorization from 'modules/authorization/Authorization';
import { createAuthorizationComponent } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import { AdminNavLink } from '../AdminNavLink';
import { AdminNavGroup } from '../AdminNavGroup';
import constants from '../../constants';
import css from './AdminPanelLayout.scss';

const Auth = createAuthorizationComponent(constants.access);

/* eslint-disable @typescript-eslint/no-explicit-any */
interface Props {
  match: any;
  modules: any;
}
/* eslint-enable @typescript-eslint/no-explicit-any */

const AdminPanelRouter = ({ match, modules }: Props) => (
  <Auth>
    <TitleChain>Админка</TitleChain>
    <div className={css.b}>
      <div className={css.b__links}>
        {modules.map((module) => (
          <Authorization key={module.url} access={module.access}>
            {module.navComponent && <module.navComponent url={`${match.url}${module.url}`} />}
            {module.group && (
              <AdminNavGroup title={module.lang.ru}>
                {module.items.list.map((key) => (
                  <AdminNavLink key={key} to={`${match.url}${module.url}/${key}`}>
                    {module.items.map[key].ru}
                  </AdminNavLink>
                ))}
              </AdminNavGroup>
            )}
            {!module.navComponent && !module.group && (
              <AdminNavLink to={`${match.url}${module.url}`}>{module.lang.ru}</AdminNavLink>
            )}
          </Authorization>
        ))}
      </div>
      <Switch>
        {modules.map((module) => (
          <Route
            key={module.url}
            path={`${match.url}${module.url}${module.params || ''}`}
            render={(props) => (
              <Authorization access={module.access} showError>
                {React.createElement(module.router, props)}
              </Authorization>
            )}
          />
        ))}
      </Switch>
    </div>
  </Auth>
);

export default AdminPanelRouter;
