import * as React from 'react';
import { get } from 'api/common';
import Button from '@crm/components/dist/lego2/Button';

export default class InvalidateCache extends React.Component {
  public state = { isFetch: false };

  public componentWillUnmount(): void {
    if (this.promise) {
      this.promise.cancel();
    }
  }

  private handleClick = () => {
    this.setState({ isFetch: true });
    this.promise = get({
      url: '/admin/cache/invalidate',
      global: false,
      isHandleUnsuccessful: false,
    }).finally(() => {
      this.setState({ isFetch: false });
    });
  };

  private promise;

  public render() {
    const { isFetch } = this.state;

    return (
      <Button
        width="max"
        onClick={this.handleClick}
        view="action"
        disabled={isFetch}
        progress={isFetch}
      >
        Сбросить кеш
      </Button>
    );
  }
}
