import React from 'react';
import PropTypes from 'prop-types';
import RouterButton from 'components/RouterButton';
import cx from 'classnames';
import CategoriesFilter from './CategoriesFilter';
import CategoriesTree from './CategoriesTree';
import css from './Categories.scss';

const Categories = ({ className, match, ...props }) => (
  <div className={cx(className, css.b)}>
    <div className={css.b__header}>
      <RouterButton to="/admin/categories/new">Создать</RouterButton>
      <CategoriesFilter />
    </div>
    <CategoriesTree className={css.b__tree} classNameTree={css.b__treeRoot} {...props} />
  </div>
);

Categories.propTypes = {
  className: PropTypes.string,
  view: PropTypes.string,
};

Categories.defaultProps = {
  className: undefined,
  view: 'default',
};

export default Categories;
