import { connect } from 'react-redux';
import connectorTreeView from 'containers/TreeSelect/connectorTreeView';
import FilterTreeView from 'containers/TreeSelect/FilterTreeView';
import { getFormValues } from 'redux-form';
import { CATEGORY_TREE_NAME } from '../../constants';
import Category from './Category';

const SAVE_UI_KEYS = ['collapseMap'];

const predicate = (node, text) => {
  if (node) {
    let isMatch = false;
    let resultNode = node;

    if (node.name) {
      const index = node.name.toLowerCase().indexOf(text);
      isMatch = index !== -1;
      if (isMatch) {
        resultNode = { ...node, searchRange: [index, index + text.length] };
      }
    }

    const { tags } = node;
    if (Array.isArray(tags) && tags.length) {
      let isMatchTags = false;
      const resultTags = tags.map(tag => {
        const { name } = tag;
        if (name) {
          const index = name.toLowerCase().indexOf(text);
          const isMatchTag = index !== -1;
          if (isMatchTag) {
            isMatchTags = isMatchTags || isMatchTag;
            return {
              ...tag,
              searchRange: [index, index + text.length],
            };
          }
        }

        return tag;
      });

      if (isMatchTags) {
        isMatch = isMatch || isMatchTags;
        resultNode = { ...resultNode, tags: resultTags };
      }
    }

    if (isMatch) {
      return resultNode;
    }
  }

  return null;
};

const CategoriesContainer = connectorTreeView({
  name: CATEGORY_TREE_NAME,
  endpoint: '/view/support/category/list/admin',
})(FilterTreeView);

const mapState = (state, ownProps) => ({
  componentNode: Category,
  destroyOnUnmount: true,
  predicate,
  saveUI: SAVE_UI_KEYS,
  requestParams: getFormValues(CATEGORY_TREE_NAME)(state),
  getRef: ownProps.getRef,
});

export default connect(mapState)(CategoriesContainer);
